#!/bin/sh
# This script deletes the partition table of the given device
# and creates a new ext3 partition on it.

print_usage()
{
	echo "Usage:"
	echo "format-device.sh device"
	echo "e.g.: format-device.sh /dev/mmcblk1"
}

target_device=$1

if [ "$target_device" = "" ] 
then
  echo "not enough arguments"
  print_usage
  exit 1
fi

if [ ! -e $target_device ]
then
  echo "target device does not exist"
  exit 1
fi

if [ ! "`echo $target_device| cut -b 0-4`" = "/dev" ]
then
  echo "target device is not in /dev"
  exit 1
fi

echo "deleting partition table"
dd if=/dev/zero of=$target_device bs=512 count=1 conv=notrunc
echo "creating partition"
printf ",,83,,\n" | sfdisk $target_device
echo "creating filesystem"
mkfs.ext3 ${target_device}p1
